<?php

namespace App\Models;

use App\Models\Category;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Blog extends Model
{
    use HasFactory;

    protected $fillable=['blog_type','category_id','heading','short_description','description','image','published_by','author',
    'weight','meta_title','meta_description','meta_keyword','slug','status'];


    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function tags()
    {
        return $this->belongsToMany(Tag::class);
    }


    public function hasTag($tagId){
        return in_array($tagId,$this->tags->pluck('id')->toArray());

    }

    public function scopeSearched(){

    $search=request()->query('search');
     if(!$search){
         return $query;
     }


return $query->where('name','LIKE','%'.$search.'%');

    }

    
}
